@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Request routing rule of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property backendHttpSettings Backend http settings resource of the application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property httpListener Http listener resource of the application gateway.
 * @property id Resource ID.
 * @property loadDistributionPolicy Load Distribution Policy resource of the application gateway.
 * @property name Name of the request routing rule that is unique within an Application Gateway.
 * @property priority Priority of the request routing rule.
 * @property provisioningState The provisioning state of the request routing rule resource.
 * @property redirectConfiguration Redirect configuration resource of the application gateway.
 * @property rewriteRuleSet Rewrite Rule Set resource in Basic rule of the application gateway.
 * @property ruleType Rule type.
 * @property type Type of the resource.
 * @property urlPathMap URL path map resource of the application gateway.
 */
public data class ApplicationGatewayRequestRoutingRuleResponse(
    public val backendAddressPool: SubResourceResponse? = null,
    public val backendHttpSettings: SubResourceResponse? = null,
    public val etag: String,
    public val httpListener: SubResourceResponse? = null,
    public val id: String? = null,
    public val loadDistributionPolicy: SubResourceResponse? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val redirectConfiguration: SubResourceResponse? = null,
    public val rewriteRuleSet: SubResourceResponse? = null,
    public val ruleType: String? = null,
    public val type: String,
    public val urlPathMap: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRequestRoutingRuleResponse):
            ApplicationGatewayRequestRoutingRuleResponse = ApplicationGatewayRequestRoutingRuleResponse(
            backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backendHttpSettings = javaType.backendHttpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            httpListener = javaType.httpListener().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            loadDistributionPolicy = javaType.loadDistributionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            redirectConfiguration = javaType.redirectConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rewriteRuleSet = javaType.rewriteRuleSet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ruleType = javaType.ruleType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            urlPathMap = javaType.urlPathMap().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
