@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Routing rule of an application gateway.
 * @property backendAddressPool Backend address pool resource of the application gateway.
 * @property backendSettings Backend settings resource of the application gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property listener Listener resource of the application gateway.
 * @property name Name of the routing rule that is unique within an Application Gateway.
 * @property priority Priority of the routing rule.
 * @property provisioningState The provisioning state of the request routing rule resource.
 * @property ruleType Rule type.
 * @property type Type of the resource.
 */
public data class ApplicationGatewayRoutingRuleResponse(
    public val backendAddressPool: SubResourceResponse? = null,
    public val backendSettings: SubResourceResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val listener: SubResourceResponse? = null,
    public val name: String? = null,
    public val priority: Int,
    public val provisioningState: String,
    public val ruleType: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewayRoutingRuleResponse):
            ApplicationGatewayRoutingRuleResponse = ApplicationGatewayRoutingRuleResponse(
            backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backendSettings = javaType.backendSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            listener = javaType.listener().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            provisioningState = javaType.provisioningState(),
            ruleType = javaType.ruleType().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
