@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * SKU of an application gateway.
 * @property capacity Capacity (instance count) of an application gateway.
 * @property name Name of an application gateway SKU.
 * @property tier Tier of an application gateway.
 */
public data class ApplicationGatewaySkuResponse(
    public val capacity: Int? = null,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewaySkuResponse):
            ApplicationGatewaySkuResponse = ApplicationGatewaySkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
