@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SSL certificates of an application gateway.
 * @property data Base-64 encoded pfx certificate. Only applicable in PUT Request.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the SSL certificate that is unique within an Application Gateway.
 * @property password Password for the pfx file specified in data. Only applicable in PUT request.
 * @property provisioningState The provisioning state of the SSL certificate resource.
 * @property publicCertData Base-64 encoded Public cert data corresponding to pfx specified in data. Only applicable in GET request.
 * @property type Type of the resource.
 */
public data class ApplicationGatewaySslCertificateResponse(
    public val `data`: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val keyVaultSecretId: String? = null,
    public val name: String? = null,
    public val password: String? = null,
    public val provisioningState: String,
    public val publicCertData: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ApplicationGatewaySslCertificateResponse):
            ApplicationGatewaySslCertificateResponse = ApplicationGatewaySslCertificateResponse(
            `data` = javaType.`data`().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            keyVaultSecretId = javaType.keyVaultSecretId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            password = javaType.password().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicCertData = javaType.publicCertData(),
            type = javaType.type(),
        )
    }
}
