@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * NAT rule collection resource.
 * @property action The action type of a NAT rule collection.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
 * @property priority Priority of the NAT rule collection resource.
 * @property provisioningState The provisioning state of the NAT rule collection resource.
 * @property rules Collection of rules used by a NAT rule collection.
 */
public data class AzureFirewallNatRuleCollectionResponse(
    public val action: AzureFirewallNatRCActionResponse? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val rules: List<AzureFirewallNatRuleResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.AzureFirewallNatRuleCollectionResponse):
            AzureFirewallNatRuleCollectionResponse = AzureFirewallNatRuleCollectionResponse(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNatRCActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
