@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Bastion Shareable Link.
 * @property bsl The unique Bastion Shareable Link to the virtual machine.
 * @property createdAt The time when the link was created.
 * @property message Optional field indicating the warning or error message related to the vm in case of partial failure.
 * @property vm Reference of the virtual machine resource.
 */
public data class BastionShareableLinkResponse(
    public val bsl: String,
    public val createdAt: String,
    public val message: String,
    public val vm: VMResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.BastionShareableLinkResponse):
            BastionShareableLinkResponse = BastionShareableLinkResponse(
            bsl = javaType.bsl(),
            createdAt = javaType.createdAt(),
            message = javaType.message(),
            vm = javaType.vm().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.VMResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
