@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cross tenant scopes.
 * @property managementGroups List of management groups.
 * @property subscriptions List of subscriptions.
 * @property tenantId Tenant ID.
 */
public data class CrossTenantScopesResponse(
    public val managementGroups: List<String>,
    public val subscriptions: List<String>,
    public val tenantId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.CrossTenantScopesResponse):
            CrossTenantScopesResponse = CrossTenantScopesResponse(
            managementGroups = javaType.managementGroups().map({ args0 -> args0 }),
            subscriptions = javaType.subscriptions().map({ args0 -> args0 }),
            tenantId = javaType.tenantId(),
        )
    }
}
