@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains the DDoS protection settings of the public IP.
 * @property ddosCustomPolicy The DDoS custom policy associated with the public IP.
 * @property ddosProtectionPlan The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
 * @property protectionCoverage The DDoS protection policy customizability of the public IP. Only standard coverage will have the ability to be customized.
 * @property protectionMode The DDoS protection mode of the public IP
 */
public data class DdosSettingsResponse(
    public val ddosCustomPolicy: SubResourceResponse? = null,
    public val ddosProtectionPlan: SubResourceResponse? = null,
    public val protectionCoverage: String? = null,
    public val protectionMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.DdosSettingsResponse):
            DdosSettingsResponse = DdosSettingsResponse(
            ddosCustomPolicy = javaType.ddosCustomPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ddosProtectionPlan = javaType.ddosProtectionPlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protectionCoverage = javaType.protectionCoverage().map({ args0 -> args0 }).orElse(null),
            protectionMode = javaType.protectionMode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
