@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Effective Virtual Network
 * @property id Effective vnet Id.
 * @property location Location of vnet.
 * @property membershipType Membership Type.
 */
public data class EffectiveVirtualNetworkResponse(
    public val id: String? = null,
    public val location: String? = null,
    public val membershipType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.EffectiveVirtualNetworkResponse):
            EffectiveVirtualNetworkResponse = EffectiveVirtualNetworkResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            membershipType = javaType.membershipType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
