@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Minimum and maximum number of scale units to deploy.
 * @property max Maximum number of scale units deployed for ExpressRoute gateway.
 * @property min Minimum number of scale units deployed for ExpressRoute gateway.
 */
public data class ExpressRouteGatewayPropertiesResponseBounds(
    public val max: Int? = null,
    public val min: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ExpressRouteGatewayPropertiesResponseBounds):
            ExpressRouteGatewayPropertiesResponseBounds = ExpressRouteGatewayPropertiesResponseBounds(
            max = javaType.max().map({ args0 -> args0 }).orElse(null),
            min = javaType.min().map({ args0 -> args0 }).orElse(null),
        )
    }
}
