@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Configuration for intrusion detection mode and rules.
 * @property configuration Intrusion detection configuration properties.
 * @property mode Intrusion detection general state.
 */
public data class FirewallPolicyIntrusionDetectionResponse(
    public val configuration: FirewallPolicyIntrusionDetectionConfigurationResponse? = null,
    public val mode: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyIntrusionDetectionResponse):
            FirewallPolicyIntrusionDetectionResponse = FirewallPolicyIntrusionDetectionResponse(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyIntrusionDetectionConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
