@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Properties of the application rule protocol.
 * @property port Port number for the protocol, cannot be greater than 64000.
 * @property protocolType Protocol type.
 */
public data class FirewallPolicyRuleConditionApplicationProtocolResponse(
    public val port: Int? = null,
    public val protocolType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyRuleConditionApplicationProtocolResponse):
            FirewallPolicyRuleConditionApplicationProtocolResponse =
            FirewallPolicyRuleConditionApplicationProtocolResponse(
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                protocolType = javaType.protocolType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
