@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * SQL Settings in Firewall Policy.
 * @property allowSqlRedirect A flag to indicate if SQL Redirect traffic filtering is enabled. Turning on the flag requires no rule using port 11000-11999.
 */
public data class FirewallPolicySQLResponse(
    public val allowSqlRedirect: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicySQLResponse):
            FirewallPolicySQLResponse = FirewallPolicySQLResponse(
            allowSqlRedirect = javaType.allowSqlRedirect().map({ args0 -> args0 }).orElse(null),
        )
    }
}
