@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule group override setting.
 * @property exclusions Describes the exclusions that are applied to all rules in the group.
 * @property ruleGroupName Describes the managed rule group to override.
 * @property rules List of rules that will be disabled. If none specified, all rules in the group will be disabled.
 */
public data class FrontDoorManagedRuleGroupOverrideResponse(
    public val exclusions: List<ManagedRuleExclusionResponse>? = null,
    public val ruleGroupName: String,
    public val rules: List<FrontDoorManagedRuleOverrideResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontDoorManagedRuleGroupOverrideResponse):
            FrontDoorManagedRuleGroupOverrideResponse = FrontDoorManagedRuleGroupOverrideResponse(
            exclusions = javaType.exclusions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleExclusionResponse.Companion.toKotlin(args0)
                })
            }),
            ruleGroupName = javaType.ruleGroupName(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontDoorManagedRuleOverrideResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
