@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define a match condition.
 * @property matchValue List of possible match values.
 * @property matchVariable Request variable to compare with.
 * @property negateCondition Describes if the result of this condition should be negated.
 * @property operator Comparison type to use for matching with the variable value.
 * @property selector Match against a specific key from the QueryString, PostArgs, RequestHeader or Cookies variables. Default is null.
 * @property transforms List of transforms.
 */
public data class FrontDoorMatchConditionResponse(
    public val matchValue: List<String>,
    public val matchVariable: String,
    public val negateCondition: Boolean? = null,
    public val `operator`: String,
    public val selector: String? = null,
    public val transforms: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontDoorMatchConditionResponse):
            FrontDoorMatchConditionResponse = FrontDoorMatchConditionResponse(
            matchValue = javaType.matchValue().map({ args0 -> args0 }),
            matchVariable = javaType.matchVariable(),
            negateCondition = javaType.negateCondition().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`(),
            selector = javaType.selector().map({ args0 -> args0 }).orElse(null),
            transforms = javaType.transforms().map({ args0 -> args0 }),
        )
    }
}
