@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Gateway routing details.
 * @property asPath The route's AS path sequence.
 * @property localAddress The gateway's local address.
 * @property network The route's network prefix.
 * @property nextHop The route's next hop.
 * @property origin The source this route was learned from.
 * @property sourcePeer The peer this route was learned from.
 * @property weight The route's weight.
 */
public data class GatewayRouteResponse(
    public val asPath: String,
    public val localAddress: String,
    public val network: String,
    public val nextHop: String,
    public val origin: String,
    public val sourcePeer: String,
    public val weight: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GatewayRouteResponse):
            GatewayRouteResponse = GatewayRouteResponse(
            asPath = javaType.asPath(),
            localAddress = javaType.localAddress(),
            network = javaType.network(),
            nextHop = javaType.nextHop(),
            origin = javaType.origin(),
            sourcePeer = javaType.sourcePeer(),
            weight = javaType.weight(),
        )
    }
}
