@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Response for GetActiveSessions.
 * @property nextLink The URL to get the next set of results.
 * @property value List of active sessions on the bastion.
 */
public data class GetActiveSessionsResult(
    public val nextLink: String? = null,
    public val `value`: List<BastionActiveSessionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetActiveSessionsResult):
            GetActiveSessionsResult = GetActiveSessionsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BastionActiveSessionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
