@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Firewall resource.
 * @property additionalProperties The additional properties used to further config this azure firewall.
 * @property applicationRuleCollections Collection of application rule collections used by Azure Firewall.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property firewallPolicy The firewallPolicy associated with this azure firewall.
 * @property hubIPAddresses IP addresses associated with AzureFirewall.
 * @property id Resource ID.
 * @property ipConfigurations IP configuration of the Azure Firewall resource.
 * @property ipGroups IpGroups associated with AzureFirewall.
 * @property location Resource location.
 * @property managementIpConfiguration IP configuration of the Azure Firewall used for management traffic.
 * @property name Resource name.
 * @property natRuleCollections Collection of NAT rule collections used by Azure Firewall.
 * @property networkRuleCollections Collection of network rule collections used by Azure Firewall.
 * @property provisioningState The provisioning state of the Azure firewall resource.
 * @property sku The Azure Firewall Resource SKU.
 * @property tags Resource tags.
 * @property threatIntelMode The operation mode for Threat Intelligence.
 * @property type Resource type.
 * @property virtualHub The virtualHub to which the firewall belongs.
 * @property zones A list of availability zones denoting where the resource needs to come from.
 */
public data class GetAzureFirewallResult(
    public val additionalProperties: Map<String, String>? = null,
    public val applicationRuleCollections: List<AzureFirewallApplicationRuleCollectionResponse>? =
        null,
    public val etag: String,
    public val firewallPolicy: SubResourceResponse? = null,
    public val hubIPAddresses: HubIPAddressesResponse? = null,
    public val id: String? = null,
    public val ipConfigurations: List<AzureFirewallIPConfigurationResponse>? = null,
    public val ipGroups: List<AzureFirewallIpGroupsResponse>,
    public val location: String? = null,
    public val managementIpConfiguration: AzureFirewallIPConfigurationResponse? = null,
    public val name: String,
    public val natRuleCollections: List<AzureFirewallNatRuleCollectionResponse>? = null,
    public val networkRuleCollections: List<AzureFirewallNetworkRuleCollectionResponse>? = null,
    public val provisioningState: String,
    public val sku: AzureFirewallSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val threatIntelMode: String? = null,
    public val type: String,
    public val virtualHub: SubResourceResponse? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetAzureFirewallResult):
            GetAzureFirewallResult = GetAzureFirewallResult(
            additionalProperties = javaType.additionalProperties().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            applicationRuleCollections = javaType.applicationRuleCollections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallApplicationRuleCollectionResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            firewallPolicy = javaType.firewallPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hubIPAddresses = javaType.hubIPAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HubIPAddressesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            ipGroups = javaType.ipGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIpGroupsResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managementIpConfiguration = javaType.managementIpConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            natRuleCollections = javaType.natRuleCollections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNatRuleCollectionResponse.Companion.toKotlin(args0)
                })
            }),
            networkRuleCollections = javaType.networkRuleCollections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallNetworkRuleCollectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AzureFirewallSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            threatIntelMode = javaType.threatIntelMode().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
