@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnServerConfigurationPolicyGroup Resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property isDefault Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property p2SConnectionConfigurations List of references to P2SConnectionConfigurations.
 * @property policyMembers Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
 * @property priority Priority for VpnServerConfigurationPolicyGroup.
 * @property provisioningState The provisioning state of the VpnServerConfigurationPolicyGroup resource.
 * @property type Resource type.
 */
public data class GetConfigurationPolicyGroupResult(
    public val etag: String,
    public val id: String? = null,
    public val isDefault: Boolean? = null,
    public val name: String? = null,
    public val p2SConnectionConfigurations: List<SubResourceResponse>,
    public val policyMembers: List<VpnServerConfigurationPolicyGroupMemberResponse>? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetConfigurationPolicyGroupResult):
            GetConfigurationPolicyGroupResult = GetConfigurationPolicyGroupResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isDefault = javaType.isDefault().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            p2SConnectionConfigurations = javaType.p2SConnectionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            policyMembers = javaType.policyMembers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupMemberResponse.Companion.toKotlin(args0)
                })
            }),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
