@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about the connection monitor.
 * @property autoStart Determines if the connection monitor will start automatically once created.
 * @property connectionMonitorType Type of connection monitor.
 * @property destination Describes the destination of connection monitor.
 * @property endpoints List of connection monitor endpoints.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id ID of the connection monitor.
 * @property location Connection monitor location.
 * @property monitoringIntervalInSeconds Monitoring interval in seconds.
 * @property monitoringStatus The monitoring status of the connection monitor.
 * @property name Name of the connection monitor.
 * @property notes Optional notes to be associated with the connection monitor.
 * @property outputs List of connection monitor outputs.
 * @property provisioningState The provisioning state of the connection monitor.
 * @property source Describes the source of connection monitor.
 * @property startTime The date and time when the connection monitor was started.
 * @property tags Connection monitor tags.
 * @property testConfigurations List of connection monitor test configurations.
 * @property testGroups List of connection monitor test groups.
 * @property type Connection monitor type.
 */
public data class GetConnectionMonitorResult(
    public val autoStart: Boolean? = null,
    public val connectionMonitorType: String,
    public val destination: ConnectionMonitorDestinationResponse? = null,
    public val endpoints: List<ConnectionMonitorEndpointResponse>? = null,
    public val etag: String,
    public val id: String,
    public val location: String? = null,
    public val monitoringIntervalInSeconds: Int? = null,
    public val monitoringStatus: String,
    public val name: String,
    public val notes: String? = null,
    public val outputs: List<ConnectionMonitorOutputResponse>? = null,
    public val provisioningState: String,
    public val source: ConnectionMonitorSourceResponse? = null,
    public val startTime: String,
    public val tags: Map<String, String>? = null,
    public val testConfigurations: List<ConnectionMonitorTestConfigurationResponse>? = null,
    public val testGroups: List<ConnectionMonitorTestGroupResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetConnectionMonitorResult):
            GetConnectionMonitorResult = GetConnectionMonitorResult(
            autoStart = javaType.autoStart().map({ args0 -> args0 }).orElse(null),
            connectionMonitorType = javaType.connectionMonitorType(),
            destination = javaType.destination().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorDestinationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            monitoringIntervalInSeconds = javaType.monitoringIntervalInSeconds().map({ args0 ->
                args0
            }).orElse(null),
            monitoringStatus = javaType.monitoringStatus(),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            outputs = javaType.outputs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorOutputResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            source = javaType.source().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorSourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            testConfigurations = javaType.testConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            testGroups = javaType.testGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ConnectionMonitorTestGroupResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
