@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Custom IP prefix resource.
 * @property asn The ASN for CIDR advertising. Should be an integer as string.
 * @property authorizationMessage Authorization message for WAN validation.
 * @property childCustomIpPrefixes The list of all Children for IPv6 /48 CustomIpPrefix.
 * @property cidr The prefix range in CIDR notation. Should include the start address and the prefix length.
 * @property commissionedState The commissioned state of the Custom IP Prefix.
 * @property customIpPrefixParent The Parent CustomIpPrefix for IPv6 /64 CustomIpPrefix.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteAdvertise Whether to do express route advertise.
 * @property extendedLocation The extended location of the custom IP prefix.
 * @property failedReason The reason why resource is in failed state.
 * @property geo The Geo for CIDR advertising. Should be an Geo code.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property noInternetAdvertise Whether to Advertise the range to Internet.
 * @property prefixType Type of custom IP prefix. Should be Singular, Parent, or Child.
 * @property provisioningState The provisioning state of the custom IP prefix resource.
 * @property publicIpPrefixes The list of all referenced PublicIpPrefixes.
 * @property resourceGuid The resource GUID property of the custom IP prefix resource.
 * @property signedMessage Signed message for WAN validation.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class GetCustomIPPrefixResult(
    public val asn: String? = null,
    public val authorizationMessage: String? = null,
    public val childCustomIpPrefixes: List<SubResourceResponse>,
    public val cidr: String? = null,
    public val commissionedState: String? = null,
    public val customIpPrefixParent: SubResourceResponse? = null,
    public val etag: String,
    public val expressRouteAdvertise: Boolean? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val failedReason: String,
    public val geo: String? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val noInternetAdvertise: Boolean? = null,
    public val prefixType: String? = null,
    public val provisioningState: String,
    public val publicIpPrefixes: List<SubResourceResponse>,
    public val resourceGuid: String,
    public val signedMessage: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetCustomIPPrefixResult):
            GetCustomIPPrefixResult = GetCustomIPPrefixResult(
            asn = javaType.asn().map({ args0 -> args0 }).orElse(null),
            authorizationMessage = javaType.authorizationMessage().map({ args0 -> args0 }).orElse(null),
            childCustomIpPrefixes = javaType.childCustomIpPrefixes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            cidr = javaType.cidr().map({ args0 -> args0 }).orElse(null),
            commissionedState = javaType.commissionedState().map({ args0 -> args0 }).orElse(null),
            customIpPrefixParent = javaType.customIpPrefixParent().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            expressRouteAdvertise = javaType.expressRouteAdvertise().map({ args0 -> args0 }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failedReason = javaType.failedReason(),
            geo = javaType.geo().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            noInternetAdvertise = javaType.noInternetAdvertise().map({ args0 -> args0 }).orElse(null),
            prefixType = javaType.prefixType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIpPrefixes = javaType.publicIpPrefixes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuid = javaType.resourceGuid(),
            signedMessage = javaType.signedMessage().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
