@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A DDoS custom policy in a resource group.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the DDoS custom policy resource.
 * @property resourceGuid The resource GUID property of the DDoS custom policy resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetDdosCustomPolicyResult(
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDdosCustomPolicyResult):
            GetDdosCustomPolicyResult = GetDdosCustomPolicyResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
