@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents the properties of the Dns Resource Reference Result.
 * @property dnsResourceReferences The result of dns resource reference request. A list of dns resource references for each of the azure resource in the request
 */
public data class GetDnsResourceReferenceByTarResourcesResult(
    public val dnsResourceReferences: List<DnsResourceReferenceResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDnsResourceReferenceByTarResourcesResult):
            GetDnsResourceReferenceByTarResourcesResult = GetDnsResourceReferenceByTarResourcesResult(
            dnsResourceReferences = javaType.dnsResourceReferences().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DnsResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
