@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule Group resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property priority Priority of the Firewall Policy Rule Group resource.
 * @property provisioningState The provisioning state of the firewall policy rule group resource.
 * @property rules Group of Firewall Policy rules.
 * @property type Rule Group type.
 */
public data class GetFirewallPolicyRuleGroupResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val rules: List<Either<FirewallPolicyFilterRuleResponse, FirewallPolicyNatRuleResponse>>? =
        null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFirewallPolicyRuleGroupResult):
            GetFirewallPolicyRuleGroupResult = GetFirewallPolicyRuleGroupResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            rules = javaType.rules().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyFilterRuleResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }),
            type = javaType.type(),
        )
    }
}
