@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * NetworkVirtualAppliance Resource.
 * @property additionalNics Details required for Additional Network Interface.
 * @property addressPrefix Address Prefix.
 * @property bootStrapConfigurationBlobs BootStrapConfigurationBlobs storage URLs.
 * @property cloudInitConfiguration CloudInitConfiguration string in plain text.
 * @property cloudInitConfigurationBlobs CloudInitConfigurationBlob storage URLs.
 * @property delegation The delegation for the Virtual Appliance
 * @property deploymentType The deployment type. PartnerManaged for the SaaS NVA
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property identity The service principal that has read access to cloud-init and config blob.
 * @property inboundSecurityRules List of references to InboundSecurityRules.
 * @property location Resource location.
 * @property name Resource name.
 * @property nvaSku Network Virtual Appliance SKU.
 * @property partnerManagedResource The delegation for the Virtual Appliance
 * @property provisioningState The provisioning state of the resource.
 * @property sshPublicKey Public key for SSH login.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualApplianceAsn VirtualAppliance ASN. Microsoft private, public and IANA reserved ASN are not supported.
 * @property virtualApplianceNics List of Virtual Appliance Network Interfaces.
 * @property virtualApplianceSites List of references to VirtualApplianceSite.
 * @property virtualHub The Virtual Hub where Network Virtual Appliance is being deployed.
 */
public data class GetNetworkVirtualApplianceResult(
    public val additionalNics: List<VirtualApplianceAdditionalNicPropertiesResponse>? = null,
    public val addressPrefix: String,
    public val bootStrapConfigurationBlobs: List<String>? = null,
    public val cloudInitConfiguration: String? = null,
    public val cloudInitConfigurationBlobs: List<String>? = null,
    public val delegation: DelegationPropertiesResponse? = null,
    public val deploymentType: String,
    public val etag: String,
    public val id: String? = null,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val inboundSecurityRules: List<SubResourceResponse>,
    public val location: String? = null,
    public val name: String,
    public val nvaSku: VirtualApplianceSkuPropertiesResponse? = null,
    public val partnerManagedResource: PartnerManagedResourcePropertiesResponse? = null,
    public val provisioningState: String,
    public val sshPublicKey: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualApplianceAsn: Double? = null,
    public val virtualApplianceNics: List<VirtualApplianceNicPropertiesResponse>,
    public val virtualApplianceSites: List<SubResourceResponse>,
    public val virtualHub: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkVirtualApplianceResult):
            GetNetworkVirtualApplianceResult = GetNetworkVirtualApplianceResult(
            additionalNics = javaType.additionalNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceAdditionalNicPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            addressPrefix = javaType.addressPrefix(),
            bootStrapConfigurationBlobs = javaType.bootStrapConfigurationBlobs().map({ args0 -> args0 }),
            cloudInitConfiguration = javaType.cloudInitConfiguration().map({ args0 -> args0 }).orElse(null),
            cloudInitConfigurationBlobs = javaType.cloudInitConfigurationBlobs().map({ args0 -> args0 }),
            delegation = javaType.delegation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DelegationPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentType = javaType.deploymentType(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inboundSecurityRules = javaType.inboundSecurityRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            nvaSku = javaType.nvaSku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceSkuPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            partnerManagedResource = javaType.partnerManagedResource().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PartnerManagedResourcePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sshPublicKey = javaType.sshPublicKey().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualApplianceAsn = javaType.virtualApplianceAsn().map({ args0 -> args0 }).orElse(null),
            virtualApplianceNics = javaType.virtualApplianceNics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualApplianceNicPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            virtualApplianceSites = javaType.virtualApplianceSites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
