@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Private endpoint resource.
 * @property applicationSecurityGroups Application security groups in which the private endpoint IP configuration is included.
 * @property customDnsConfigs An array of custom dns configurations.
 * @property customNetworkInterfaceName The custom name of the network interface attached to the private endpoint.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the load balancer.
 * @property id Resource ID.
 * @property ipConfigurations A list of IP configurations of the private endpoint. This will be used to map to the First Party Service's endpoints.
 * @property location Resource location.
 * @property manualPrivateLinkServiceConnections A grouping of information about the connection to the remote resource. Used when the network admin does not have access to approve connections to the remote resource.
 * @property name Resource name.
 * @property networkInterfaces An array of references to the network interfaces created for this private endpoint.
 * @property privateLinkServiceConnections A grouping of information about the connection to the remote resource.
 * @property provisioningState The provisioning state of the private endpoint resource.
 * @property subnet The ID of the subnet from which the private IP will be allocated.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetPrivateEndpointResult(
    public val applicationSecurityGroups: List<ApplicationSecurityGroupResponse>? = null,
    public val customDnsConfigs: List<CustomDnsConfigPropertiesFormatResponse>? = null,
    public val customNetworkInterfaceName: String? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String? = null,
    public val ipConfigurations: List<PrivateEndpointIPConfigurationResponse>? = null,
    public val location: String? = null,
    public val manualPrivateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? =
        null,
    public val name: String,
    public val networkInterfaces: List<NetworkInterfaceResponse>,
    public val privateLinkServiceConnections: List<PrivateLinkServiceConnectionResponse>? = null,
    public val provisioningState: String,
    public val subnet: SubnetResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateEndpointResult):
            GetPrivateEndpointResult = GetPrivateEndpointResult(
            applicationSecurityGroups = javaType.applicationSecurityGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }),
            customDnsConfigs = javaType.customDnsConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.CustomDnsConfigPropertiesFormatResponse.Companion.toKotlin(args0)
                })
            }),
            customNetworkInterfaceName = javaType.customNetworkInterfaceName().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            manualPrivateLinkServiceConnections = javaType.manualPrivateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceConnections = javaType.privateLinkServiceConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
