@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Public IP prefix resource.
 * @property customIPPrefix The customIpPrefix that this prefix is associated with.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the public ip address.
 * @property id Resource ID.
 * @property ipPrefix The allocated Prefix.
 * @property ipTags The list of tags associated with the public IP prefix.
 * @property loadBalancerFrontendIpConfiguration The reference to load balancer frontend IP configuration associated with the public IP prefix.
 * @property location Resource location.
 * @property name Resource name.
 * @property natGateway NatGateway of Public IP Prefix.
 * @property prefixLength The Length of the Public IP Prefix.
 * @property provisioningState The provisioning state of the public IP prefix resource.
 * @property publicIPAddressVersion The public IP address version.
 * @property publicIPAddresses The list of all referenced PublicIPAddresses.
 * @property resourceGuid The resource GUID property of the public IP prefix resource.
 * @property sku The public IP prefix SKU.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class GetPublicIPPrefixResult(
    public val customIPPrefix: SubResourceResponse? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String? = null,
    public val ipPrefix: String,
    public val ipTags: List<IpTagResponse>? = null,
    public val loadBalancerFrontendIpConfiguration: SubResourceResponse,
    public val location: String? = null,
    public val name: String,
    public val natGateway: NatGatewayResponse? = null,
    public val prefixLength: Int? = null,
    public val provisioningState: String,
    public val publicIPAddressVersion: String? = null,
    public val publicIPAddresses: List<ReferencedPublicIpAddressResponse>,
    public val resourceGuid: String,
    public val sku: PublicIPPrefixSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPublicIPPrefixResult):
            GetPublicIPPrefixResult = GetPublicIPPrefixResult(
            customIPPrefix = javaType.customIPPrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipPrefix = javaType.ipPrefix(),
            ipTags = javaType.ipTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancerFrontendIpConfiguration = javaType.loadBalancerFrontendIpConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            natGateway = javaType.natGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            prefixLength = javaType.prefixLength().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddressVersion = javaType.publicIPAddressVersion().map({ args0 -> args0 }).orElse(null),
            publicIPAddresses = javaType.publicIPAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ReferencedPublicIpAddressResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuid = javaType.resourceGuid(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPPrefixSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
