@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Virtual Appliance Site resource.
 * @property connectionState The current state of the VirtualHub to Peer.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hubVirtualNetworkConnection The reference to the HubVirtualNetworkConnection resource.
 * @property id Resource ID.
 * @property name Name of the connection.
 * @property peerAsn Peer ASN.
 * @property peerIp Peer IP.
 * @property provisioningState The provisioning state of the resource.
 * @property type Connection type.
 */
public data class GetVirtualHubBgpConnectionResult(
    public val connectionState: String,
    public val etag: String,
    public val hubVirtualNetworkConnection: SubResourceResponse? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val peerAsn: Double? = null,
    public val peerIp: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualHubBgpConnectionResult):
            GetVirtualHubBgpConnectionResult = GetVirtualHubBgpConnectionResult(
            connectionState = javaType.connectionState(),
            etag = javaType.etag(),
            hubVirtualNetworkConnection = javaType.hubVirtualNetworkConnection().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peerAsn = javaType.peerAsn().map({ args0 -> args0 }).orElse(null),
            peerIp = javaType.peerIp().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
