@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VpnGateway Resource.
 * @property bgpSettings Local network gateway's BGP speaker settings.
 * @property connections List of all vpn connections to the gateway.
 * @property enableBgpRouteTranslationForNat Enable BGP routes translation for NAT on this VpnGateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipConfigurations List of all IPs configured on the gateway.
 * @property isRoutingPreferenceInternet Enable Routing Preference property for the Public IP Interface of the VpnGateway.
 * @property location Resource location.
 * @property name Resource name.
 * @property natRules List of all the nat Rules associated with the gateway.
 * @property provisioningState The provisioning state of the VPN gateway resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHub The VirtualHub to which the gateway belongs.
 * @property vpnGatewayScaleUnit The scale unit for this vpn gateway.
 */
public data class GetVpnGatewayResult(
    public val bgpSettings: BgpSettingsResponse? = null,
    public val connections: List<VpnConnectionResponse>? = null,
    public val enableBgpRouteTranslationForNat: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipConfigurations: List<VpnGatewayIpConfigurationResponse>,
    public val isRoutingPreferenceInternet: Boolean? = null,
    public val location: String,
    public val name: String,
    public val natRules: List<VpnGatewayNatRuleResponse>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: SubResourceResponse? = null,
    public val vpnGatewayScaleUnit: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVpnGatewayResult):
            GetVpnGatewayResult = GetVpnGatewayResult(
            bgpSettings = javaType.bgpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            connections = javaType.connections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            enableBgpRouteTranslationForNat = javaType.enableBgpRouteTranslationForNat().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            isRoutingPreferenceInternet = javaType.isRoutingPreferenceInternet().map({ args0 ->
                args0
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            natRules = javaType.natRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnGatewayNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnGatewayScaleUnit = javaType.vpnGatewayScaleUnit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
