@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of IPConfigurationBgpPeeringAddress.
 * @property customBgpIpAddresses The list of custom BGP peering addresses which belong to IP configuration.
 * @property defaultBgpIpAddresses The list of default BGP peering addresses which belong to IP configuration.
 * @property ipconfigurationId The ID of IP configuration which belongs to gateway.
 * @property tunnelIpAddresses The list of tunnel public IP addresses which belong to IP configuration.
 */
public data class IPConfigurationBgpPeeringAddressResponse(
    public val customBgpIpAddresses: List<String>? = null,
    public val defaultBgpIpAddresses: List<String>,
    public val ipconfigurationId: String? = null,
    public val tunnelIpAddresses: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.IPConfigurationBgpPeeringAddressResponse):
            IPConfigurationBgpPeeringAddressResponse = IPConfigurationBgpPeeringAddressResponse(
            customBgpIpAddresses = javaType.customBgpIpAddresses().map({ args0 -> args0 }),
            defaultBgpIpAddresses = javaType.defaultBgpIpAddresses().map({ args0 -> args0 }),
            ipconfigurationId = javaType.ipconfigurationId().map({ args0 -> args0 }).orElse(null),
            tunnelIpAddresses = javaType.tunnelIpAddresses().map({ args0 -> args0 }),
        )
    }
}
