@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Rule of type network.
 * @property description Description of the rule.
 * @property destinationAddresses List of destination IP addresses or Service Tags.
 * @property destinationFqdns List of destination FQDNs.
 * @property destinationIpGroups List of destination IpGroups for this rule.
 * @property destinationPorts List of destination ports.
 * @property ipProtocols Array of FirewallPolicyRuleNetworkProtocols.
 * @property name Name of the rule.
 * @property ruleType Rule Type.
 * Expected value is 'NetworkRule'.
 * @property sourceAddresses List of source IP addresses for this rule.
 * @property sourceIpGroups List of source IpGroups for this rule.
 */
public data class NetworkRuleResponse(
    public val description: String? = null,
    public val destinationAddresses: List<String>? = null,
    public val destinationFqdns: List<String>? = null,
    public val destinationIpGroups: List<String>? = null,
    public val destinationPorts: List<String>? = null,
    public val ipProtocols: List<String>? = null,
    public val name: String? = null,
    public val ruleType: String,
    public val sourceAddresses: List<String>? = null,
    public val sourceIpGroups: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkRuleResponse):
            NetworkRuleResponse = NetworkRuleResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            destinationAddresses = javaType.destinationAddresses().map({ args0 -> args0 }),
            destinationFqdns = javaType.destinationFqdns().map({ args0 -> args0 }),
            destinationIpGroups = javaType.destinationIpGroups().map({ args0 -> args0 }),
            destinationPorts = javaType.destinationPorts().map({ args0 -> args0 }),
            ipProtocols = javaType.ipProtocols().map({ args0 -> args0 }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            sourceAddresses = javaType.sourceAddresses().map({ args0 -> args0 }),
            sourceIpGroups = javaType.sourceIpGroups().map({ args0 -> args0 }),
        )
    }
}
