@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * P2SConnectionConfiguration Resource.
 * @property configurationPolicyGroupAssociations List of Configuration Policy Groups that this P2SConnectionConfiguration is attached to.
 * @property enableInternetSecurity Flag indicating whether the enable internet security flag is turned on for the P2S Connections or not.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property previousConfigurationPolicyGroupAssociations List of previous Configuration Policy Groups that this P2SConnectionConfiguration was attached to.
 * @property provisioningState The provisioning state of the P2SConnectionConfiguration resource.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property vpnClientAddressPool The reference to the address space resource which represents Address space for P2S VpnClient.
 */
public data class P2SConnectionConfigurationResponse(
    public val configurationPolicyGroupAssociations: List<SubResourceResponse>,
    public val enableInternetSecurity: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val previousConfigurationPolicyGroupAssociations:
    List<VpnServerConfigurationPolicyGroupResponse>,
    public val provisioningState: String,
    public val routingConfiguration: RoutingConfigurationResponse? = null,
    public val vpnClientAddressPool: AddressSpaceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.P2SConnectionConfigurationResponse):
            P2SConnectionConfigurationResponse = P2SConnectionConfigurationResponse(
            configurationPolicyGroupAssociations = javaType.configurationPolicyGroupAssociations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            enableInternetSecurity = javaType.enableInternetSecurity().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            previousConfigurationPolicyGroupAssociations = javaType.previousConfigurationPolicyGroupAssociations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnServerConfigurationPolicyGroupResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            routingConfiguration = javaType.routingConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnClientAddressPool = javaType.vpnClientAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
