@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
 * @property exclude List of AzureVMSS instances which has to be excluded from the AzureVMSS from running packet capture.
 * @property include List of AzureVMSS instances to run packet capture on.
 */
public data class PacketCaptureMachineScopeResponse(
    public val exclude: List<String>? = null,
    public val include: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PacketCaptureMachineScopeResponse):
            PacketCaptureMachineScopeResponse = PacketCaptureMachineScopeResponse(
            exclude = javaType.exclude().map({ args0 -> args0 }),
            include = javaType.include().map({ args0 -> args0 }),
        )
    }
}
