@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the partner managed resource.
 * @property id The partner managed resource id.
 * @property internalLoadBalancerId The partner managed ILB resource id
 * @property standardLoadBalancerId The partner managed SLB resource id
 */
public data class PartnerManagedResourcePropertiesResponse(
    public val id: String,
    public val internalLoadBalancerId: String,
    public val standardLoadBalancerId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PartnerManagedResourcePropertiesResponse):
            PartnerManagedResourcePropertiesResponse = PartnerManagedResourcePropertiesResponse(
            id = javaType.id(),
            internalLoadBalancerId = javaType.internalLoadBalancerId(),
            standardLoadBalancerId = javaType.standardLoadBalancerId(),
        )
    }
}
