@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Qos Traffic Profiler IP Range properties.
 * @property endIP End IP Address.
 * @property startIP Start IP Address.
 */
public data class QosIpRangeResponse(
    public val endIP: String? = null,
    public val startIP: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.QosIpRangeResponse):
            QosIpRangeResponse = QosIpRangeResponse(
            endIP = javaType.endIP().map({ args0 -> args0 }).orElse(null),
            startIP = javaType.startIP().map({ args0 -> args0 }).orElse(null),
        )
    }
}
