@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Service Endpoint policy definitions.
 * @property description A description for this rule. Restricted to 140 chars.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the service endpoint policy definition resource.
 * @property service Service endpoint name.
 * @property serviceResources A list of service resources.
 * @property type The type of the resource.
 */
public data class ServiceEndpointPolicyDefinitionResponse(
    public val description: String? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val service: String? = null,
    public val serviceResources: List<String>? = null,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ServiceEndpointPolicyDefinitionResponse):
            ServiceEndpointPolicyDefinitionResponse = ServiceEndpointPolicyDefinitionResponse(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            service = javaType.service().map({ args0 -> args0 }).orElse(null),
            serviceResources = javaType.serviceResources().map({ args0 -> args0 }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
