@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Hub identifier.
 * @property id The resource URI for the Virtual Hub where the ExpressRoute gateway is or will be deployed. The Virtual Hub resource and the ExpressRoute gateway resource reside in the same subscription.
 */
public data class VirtualHubIdResponse(
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualHubIdResponse):
            VirtualHubIdResponse = VirtualHubIdResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
        )
    }
}
