@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VirtualHub route.
 * @property addressPrefixes List of all addressPrefixes.
 * @property nextHopIpAddress NextHop ip address.
 */
public data class VirtualHubRouteResponse(
    public val addressPrefixes: List<String>? = null,
    public val nextHopIpAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualHubRouteResponse):
            VirtualHubRouteResponse = VirtualHubRouteResponse(
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
            nextHopIpAddress = javaType.nextHopIpAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
