@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VirtualHubRouteTableV2 route.
 * @property destinationType The type of destinations.
 * @property destinations List of all destinations.
 * @property nextHopType The type of next hops.
 * @property nextHops NextHops ip address.
 */
public data class VirtualHubRouteV2Response(
    public val destinationType: String? = null,
    public val destinations: List<String>? = null,
    public val nextHopType: String? = null,
    public val nextHops: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualHubRouteV2Response):
            VirtualHubRouteV2Response = VirtualHubRouteV2Response(
            destinationType = javaType.destinationType().map({ args0 -> args0 }).orElse(null),
            destinations = javaType.destinations().map({ args0 -> args0 }),
            nextHopType = javaType.nextHopType().map({ args0 -> args0 }).orElse(null),
            nextHops = javaType.nextHops().map({ args0 -> args0 }),
        )
    }
}
