@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
 * @property enabled Indicates if encryption is enabled on the virtual network.
 * @property enforcement If the encrypted VNet allows VM that does not support encryption
 */
public data class VirtualNetworkEncryptionResponse(
    public val enabled: Boolean,
    public val enforcement: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkEncryptionResponse):
            VirtualNetworkEncryptionResponse = VirtualNetworkEncryptionResponse(
            enabled = javaType.enabled(),
            enforcement = javaType.enforcement().map({ args0 -> args0 }).orElse(null),
        )
    }
}
