@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * List of routes that control routing from VirtualHub into a virtual network connection.
 * @property bgpConnections The list of references to HubBgpConnection objects.
 * @property staticRoutes List of all Static Routes.
 * @property staticRoutesConfig Configuration for static routes on this HubVnetConnection.
 */
public data class VnetRouteResponse(
    public val bgpConnections: List<SubResourceResponse>,
    public val staticRoutes: List<StaticRouteResponse>? = null,
    public val staticRoutesConfig: StaticRoutesConfigResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VnetRouteResponse):
            VnetRouteResponse = VnetRouteResponse(
            bgpConnections = javaType.bgpConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            staticRoutes = javaType.staticRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.StaticRouteResponse.Companion.toKotlin(args0)
                })
            }),
            staticRoutesConfig = javaType.staticRoutesConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.StaticRoutesConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
