@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnClientConnectionHealth properties.
 * @property allocatedIpAddresses List of allocated ip addresses to the connected p2s vpn clients.
 * @property totalEgressBytesTransferred Total of the Egress Bytes Transferred in this connection.
 * @property totalIngressBytesTransferred Total of the Ingress Bytes Transferred in this P2S Vpn connection.
 * @property vpnClientConnectionsCount The total of p2s vpn clients connected at this time to this P2SVpnGateway.
 */
public data class VpnClientConnectionHealthResponse(
    public val allocatedIpAddresses: List<String>? = null,
    public val totalEgressBytesTransferred: Double,
    public val totalIngressBytesTransferred: Double,
    public val vpnClientConnectionsCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnClientConnectionHealthResponse):
            VpnClientConnectionHealthResponse = VpnClientConnectionHealthResponse(
            allocatedIpAddresses = javaType.allocatedIpAddresses().map({ args0 -> args0 }),
            totalEgressBytesTransferred = javaType.totalEgressBytesTransferred(),
            totalIngressBytesTransferred = javaType.totalIngressBytesTransferred(),
            vpnClientConnectionsCount = javaType.vpnClientConnectionsCount().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
