@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the revoked VPN client certificate of VpnServerConfiguration.
 * @property name The certificate name.
 * @property thumbprint The revoked VPN client certificate thumbprint.
 */
public data class VpnServerConfigVpnClientRevokedCertificateResponse(
    public val name: String? = null,
    public val thumbprint: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnServerConfigVpnClientRevokedCertificateResponse):
            VpnServerConfigVpnClientRevokedCertificateResponse =
            VpnServerConfigVpnClientRevokedCertificateResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                thumbprint = javaType.thumbprint().map({ args0 -> args0 }).orElse(null),
            )
    }
}
