@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VpnSiteLinkConnection Resource.
 * @property connectionBandwidth Expected bandwidth in MBPS.
 * @property connectionStatus The connection status.
 * @property egressBytesTransferred Egress bytes transferred.
 * @property egressNatRules List of egress NatRules.
 * @property enableBgp EnableBgp flag.
 * @property enableRateLimiting EnableBgp flag.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ingressBytesTransferred Ingress bytes transferred.
 * @property ingressNatRules List of ingress NatRules.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the VPN site link connection resource.
 * @property routingWeight Routing weight for vpn connection.
 * @property sharedKey SharedKey for the vpn connection.
 * @property type Resource type.
 * @property useLocalAzureIpAddress Use local azure ip to initiate connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property vpnConnectionProtocolType Connection protocol used for this connection.
 * @property vpnGatewayCustomBgpAddresses vpnGatewayCustomBgpAddresses used by this connection.
 * @property vpnLinkConnectionMode Vpn link connection mode.
 * @property vpnSiteLink Id of the connected vpn site link.
 */
public data class VpnSiteLinkConnectionResponse(
    public val connectionBandwidth: Int? = null,
    public val connectionStatus: String,
    public val egressBytesTransferred: Double,
    public val egressNatRules: List<SubResourceResponse>? = null,
    public val enableBgp: Boolean? = null,
    public val enableRateLimiting: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val ingressBytesTransferred: Double,
    public val ingressNatRules: List<SubResourceResponse>? = null,
    public val ipsecPolicies: List<IpsecPolicyResponse>? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val routingWeight: Int? = null,
    public val sharedKey: String? = null,
    public val type: String,
    public val useLocalAzureIpAddress: Boolean? = null,
    public val usePolicyBasedTrafficSelectors: Boolean? = null,
    public val vpnConnectionProtocolType: String? = null,
    public val vpnGatewayCustomBgpAddresses: List<GatewayCustomBgpIpAddressIpConfigurationResponse>? =
        null,
    public val vpnLinkConnectionMode: String? = null,
    public val vpnSiteLink: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnSiteLinkConnectionResponse):
            VpnSiteLinkConnectionResponse = VpnSiteLinkConnectionResponse(
            connectionBandwidth = javaType.connectionBandwidth().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus(),
            egressBytesTransferred = javaType.egressBytesTransferred(),
            egressNatRules = javaType.egressNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            enableBgp = javaType.enableBgp().map({ args0 -> args0 }).orElse(null),
            enableRateLimiting = javaType.enableRateLimiting().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ingressBytesTransferred = javaType.ingressBytesTransferred(),
            ingressNatRules = javaType.ingressNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            ipsecPolicies = javaType.ipsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routingWeight = javaType.routingWeight().map({ args0 -> args0 }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            useLocalAzureIpAddress = javaType.useLocalAzureIpAddress().map({ args0 -> args0 }).orElse(null),
            usePolicyBasedTrafficSelectors = javaType.usePolicyBasedTrafficSelectors().map({ args0 ->
                args0
            }).orElse(null),
            vpnConnectionProtocolType = javaType.vpnConnectionProtocolType().map({ args0 ->
                args0
            }).orElse(null),
            vpnGatewayCustomBgpAddresses = javaType.vpnGatewayCustomBgpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.GatewayCustomBgpIpAddressIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            vpnLinkConnectionMode = javaType.vpnLinkConnectionMode().map({ args0 -> args0 }).orElse(null),
            vpnSiteLink = javaType.vpnSiteLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
