@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines contents of a web application rule.
 * @property action Type of Actions.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property groupByUserSession List of user session identifier group by clauses.
 * @property matchConditions List of match conditions.
 * @property name The name of the resource that is unique within a policy. This name can be used to access the resource.
 * @property priority Priority of the rule. Rules with a lower value will be evaluated before rules with a higher value.
 * @property rateLimitDuration Duration over which Rate Limit policy will be applied. Applies only when ruleType is RateLimitRule.
 * @property rateLimitThreshold Rate Limit threshold to apply in case ruleType is RateLimitRule. Must be greater than or equal to 1
 * @property ruleType The rule type.
 * @property state Describes if the custom rule is in enabled or disabled state. Defaults to Enabled if not specified.
 */
public data class WebApplicationFirewallCustomRuleResponse(
    public val action: String,
    public val etag: String,
    public val groupByUserSession: List<GroupByUserSessionResponse>? = null,
    public val matchConditions: List<MatchConditionResponse>,
    public val name: String? = null,
    public val priority: Int,
    public val rateLimitDuration: String? = null,
    public val rateLimitThreshold: Int? = null,
    public val ruleType: String,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.WebApplicationFirewallCustomRuleResponse):
            WebApplicationFirewallCustomRuleResponse = WebApplicationFirewallCustomRuleResponse(
            action = javaType.action(),
            etag = javaType.etag(),
            groupByUserSession = javaType.groupByUserSession().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.GroupByUserSessionResponse.Companion.toKotlin(args0)
                })
            }),
            matchConditions = javaType.matchConditions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MatchConditionResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority(),
            rateLimitDuration = javaType.rateLimitDuration().map({ args0 -> args0 }).orElse(null),
            rateLimitThreshold = javaType.rateLimitThreshold().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
