@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.GetDataTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataProductName The data product resource name
 * @property dataTypeName The data type name.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataTypePlainArgs(
    public val dataProductName: String,
    public val dataTypeName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.GetDataTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.GetDataTypePlainArgs =
        com.pulumi.azurenative.networkanalytics.inputs.GetDataTypePlainArgs.builder()
            .dataProductName(dataProductName.let({ args0 -> args0 }))
            .dataTypeName(dataTypeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataTypePlainArgs].
 */
@PulumiTagMarker
public class GetDataTypePlainArgsBuilder internal constructor() {
    private var dataProductName: String? = null

    private var dataTypeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The data product resource name
     */
    @JvmName("lfgsdbwklhgttfws")
    public suspend fun dataProductName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataProductName = mapped
    }

    /**
     * @param value The data type name.
     */
    @JvmName("tycimcflfgyktsxy")
    public suspend fun dataTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataTypeName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("finofbwbaycmqnff")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataTypePlainArgs = GetDataTypePlainArgs(
        dataProductName = dataProductName ?: throw PulumiNullFieldException("dataProductName"),
        dataTypeName = dataTypeName ?: throw PulumiNullFieldException("dataTypeName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
