@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.VirtualNetworkRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Virtual Network Rule
 * @property action The action of virtual network rule.
 * @property id Resource ID of a subnet
 * @property state Gets the state of virtual network rule.
 */
public data class VirtualNetworkRuleArgs(
    public val action: Output<String>? = null,
    public val id: Output<String>,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.VirtualNetworkRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.VirtualNetworkRuleArgs =
        com.pulumi.azurenative.networkanalytics.inputs.VirtualNetworkRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkRuleArgs].
 */
@PulumiTagMarker
public class VirtualNetworkRuleArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var id: Output<String>? = null

    private var state: Output<String>? = null

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("ldlpkrlnxinnufll")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value Resource ID of a subnet
     */
    @JvmName("ivawrgtplvpaqlwe")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("futwbvuofpvmhngv")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("iufqithlcvbythsi")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Resource ID of a subnet
     */
    @JvmName("quafohtjqcaxwpub")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Gets the state of virtual network rule.
     */
    @JvmName("kklwqwmbwsrtfiyh")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): VirtualNetworkRuleArgs = VirtualNetworkRuleArgs(
        action = action,
        id = id ?: throw PulumiNullFieldException("id"),
        state = state,
    )
}
