@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The data product resource.
 * @property availableMinorVersions List of available minor versions of the data product resource.
 * @property consumptionEndpoints Resource links which exposed to the customer to query the data.
 * @property currentMinorVersion Current configured minor version of the data product resource.
 * @property customerEncryptionKey Customer managed encryption key details for data product.
 * @property customerManagedKeyEncryptionEnabled Flag to enable customer managed key encryption for data product.
 * @property documentation Documentation link for the data product based on definition file.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The managed service identities assigned to this resource.
 * @property keyVaultUrl Key vault url.
 * @property location The geo-location where the resource lives
 * @property majorVersion Major version of data product.
 * @property name The name of the resource
 * @property networkacls Network rule set for data product.
 * @property owners List of name or email associated with data product resource deployment.
 * @property privateLinksEnabled Flag to enable or disable private link for data product resource.
 * @property product Product name of data product.
 * @property provisioningState Latest provisioning state  of data product.
 * @property publicNetworkAccess Flag to enable or disable public access of data product resource.
 * @property publisher Data product publisher name.
 * @property purviewAccount Purview account url for data product to connect to.
 * @property purviewCollection Purview collection url for data product to connect to.
 * @property redundancy Flag to enable or disable redundancy for data product.
 * @property resourceGuid The resource GUID property of the data product resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataProductResult(
    public val availableMinorVersions: List<String>,
    public val consumptionEndpoints: ConsumptionEndpointsPropertiesResponse,
    public val currentMinorVersion: String? = null,
    public val customerEncryptionKey: EncryptionKeyDetailsResponse? = null,
    public val customerManagedKeyEncryptionEnabled: String? = null,
    public val documentation: String,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val keyVaultUrl: String,
    public val location: String,
    public val majorVersion: String,
    public val name: String,
    public val networkacls: DataProductNetworkAclsResponse? = null,
    public val owners: List<String>? = null,
    public val privateLinksEnabled: String? = null,
    public val product: String,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val publisher: String,
    public val purviewAccount: String? = null,
    public val purviewCollection: String? = null,
    public val redundancy: String? = null,
    public val resourceGuid: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.GetDataProductResult):
            GetDataProductResult = GetDataProductResult(
            availableMinorVersions = javaType.availableMinorVersions().map({ args0 -> args0 }),
            consumptionEndpoints = javaType.consumptionEndpoints().let({ args0 ->
                com.pulumi.azurenative.networkanalytics.kotlin.outputs.ConsumptionEndpointsPropertiesResponse.Companion.toKotlin(args0)
            }),
            currentMinorVersion = javaType.currentMinorVersion().map({ args0 -> args0 }).orElse(null),
            customerEncryptionKey = javaType.customerEncryptionKey().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.EncryptionKeyDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customerManagedKeyEncryptionEnabled = javaType.customerManagedKeyEncryptionEnabled().map({ args0 ->
                args0
            }).orElse(null),
            documentation = javaType.documentation(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyVaultUrl = javaType.keyVaultUrl(),
            location = javaType.location(),
            majorVersion = javaType.majorVersion(),
            name = javaType.name(),
            networkacls = javaType.networkacls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkanalytics.kotlin.outputs.DataProductNetworkAclsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            owners = javaType.owners().map({ args0 -> args0 }),
            privateLinksEnabled = javaType.privateLinksEnabled().map({ args0 -> args0 }).orElse(null),
            product = javaType.product(),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher(),
            purviewAccount = javaType.purviewAccount().map({ args0 -> args0 }).orElse(null),
            purviewCollection = javaType.purviewCollection().map({ args0 -> args0 }).orElse(null),
            redundancy = javaType.redundancy().map({ args0 -> args0 }).orElse(null),
            resourceGuid = javaType.resourceGuid(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
