@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The details for role assignment response.
 * @property dataTypeScope Data Type Scope at which the role assignment is created.
 * @property principalId Object ID of the AAD principal or security-group.
 * @property principalType Type of the principal Id: User, Group or ServicePrincipal
 * @property role Data Product role to be assigned to a user.
 * @property roleAssignmentId Id of role assignment request
 * @property roleId Role Id of the Built-In Role
 * @property userName User name.
 */
public data class RoleAssignmentDetailResponse(
    public val dataTypeScope: List<String>,
    public val principalId: String,
    public val principalType: String,
    public val role: String,
    public val roleAssignmentId: String,
    public val roleId: String,
    public val userName: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.RoleAssignmentDetailResponse):
            RoleAssignmentDetailResponse = RoleAssignmentDetailResponse(
            dataTypeScope = javaType.dataTypeScope().map({ args0 -> args0 }),
            principalId = javaType.principalId(),
            principalType = javaType.principalType(),
            role = javaType.role(),
            roleAssignmentId = javaType.roleAssignmentId(),
            roleId = javaType.roleId(),
            userName = javaType.userName(),
        )
    }
}
