@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Virtual Network Rule
 * @property action The action of virtual network rule.
 * @property id Resource ID of a subnet
 * @property state Gets the state of virtual network rule.
 */
public data class VirtualNetworkRuleResponse(
    public val action: String? = null,
    public val id: String,
    public val state: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkanalytics.outputs.VirtualNetworkRuleResponse):
            VirtualNetworkRuleResponse = VirtualNetworkRuleResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
